<?
/****************************************************************/
/* Nom du fichier       : libunimess.php                        */
/* Date de cration     : 26/03/2003                            */
/* Version              : 1.1                                   */
/* Auteur               : UNIMESS.NET                           */
/* Contact              : webmaster@unimess.net                 */
/* Description          : Class permettant l'envoi de FAX et SMS*/
/*                                                              */
/****************************************************************/

class Unimess{

var $IdLogin;		/* IdLogin fourni par UNIMESS 			   	*/
var $Login;		/* Idientifant permettant l'acces au site UNIMESS  	*/
var $Pass;		/* Mot de passe permettant l'acces au site UNIMESS 	*/
var $Mobile;		/* Numro du tlphone mobile du correspondant 		*/
var $Message;		/* Message a envoyer au correspondant 			*/
var $Marque;		/* Marque du tlphone pour encodage du logo ou sonnerie*/
var $ValeurHexa;   	/* Contenu du logo ou sonnerie en HEXA                  */
var $Cle;		/* Cle de cryptage fournie par UNIMESS			*/ 
var $Type;		/* type = FAX/SMS/LOGO/RING				*/
var $Status;		/* 1 => SMS partie / -1 => Erreur 			*/
var $Info;		/* Information sur les erreurs				*/

var $TabPhoneManufacturer; /* Tableau contenant les differentes marques de Mobile */

/* Constructeur de la classe          */
/* A parametrer avec vos informations */
function Unimess()
{
	// Modifier les parametres suivant en fonction des vos informations personnelless 
	$this->IdLogin	=	"";
	$this->Login	=	"";
	$this->Pass	=	"";
	$this->Cle	=	"";
	
	// Initialisation de Status et Info 
	// A ne pas modifier
	$this->Status	=	0;
	$this->Info	=	"";
	$this->Type	=	"";
	$this->TabPhoneManufacturer = array("Nokia" =>	1, "Ericsson" => 2, "Alcatel" => 3, "Philips" => 4, "Siemens" => 5, "Motorola" => 6, "Sagem" =>	7, "Samsung" =>	8, "Panasonic" => 9, "Mitsubishi" => 10, "Sony" => 11, "Bosch" => 12, "Trium" => 13, "Sendo" =>	14, "Benefon" => 15, "NEC" => 16);
	
}

function SetMobile($mobile)
{
	$this->Mobile	=	$mobile;	
	$this->Type	=	"SMS";
}

function SetMobileLogo($mobile)
{
	$this->Mobile	=	$mobile;	
	$this->Type	=	"LOGO";
}

function SetMobileRing($mobile)
{
	$this->Mobile	=	$mobile;	
	$this->Type	=	"RING";
}

function SetNumFax($tel)
{
	$this->NumFax	=	$tel;
	$this->Type	=	"FAX";	
}

function SetMarque($marque)
{
	$this->Marque	=	$marque;
}


// permet d'initialiser $this->Message avec une chaine de caractere
function SetMessage($message)
{
	$this->Message	=	addslashes($message);	
}

function SetMessageFromTxt($file)
{
	$fp = fopen($file, "r");
	// Recuperation du fichier
	while (!feof($fp)) 
	{
		$this->Message	.= fgets($fp, 2048);
	} /* end while */
	$this->Message	= addslashes($this->Message);	
	fclose($fp);
}

function SetLogo($valeur)
{
	$this->ValeurHexa	=	addslashes($valeur);
	$this->Type		=	"LOGO";	
} 

function SetRing($valeur)
{
	$this->ValeurHexa	=	addslashes($valeur);
	$this->Type		=	"RING";	
} 


function Send()
{
	// remplace tout les ";" par ","
	$this->Message = strtr($this->Message, ";", ",");
	// Preparation de la requete
	switch($this->Type)
	{
	case "SMS" :

		$requete_clair	 =	$this->Login;
		$requete_clair	.=	";".$this->Pass;
		$requete_clair	.=	";".$this->Type;
		$requete_clair	.=	";".$this->Mobile;
		$requete_clair	.=	";".$this->Message;
		break;
		
	case "FAX" :
	
		$requete_clair	 =	$this->Login;
		$requete_clair	.=	";".$this->Pass;
		$requete_clair	.=	";".$this->Type;
		$requete_clair	.=	";".$this->NumFax;
		$requete_clair	.=	";".$this->Message;
		break;
	
	case "LOGO" :
	case "RING" :
	
		$requete_clair	 =	$this->Login;
		$requete_clair	.=	";".$this->Pass;
		$requete_clair	.=	";".$this->Type;
		$requete_clair	.=	";".$this->Mobile;
		$requete_clair	.=	";".$this->Message;
		$requete_clair	.=	";".$this->Marque;
		$requete_clair	.=	";".$this->ValeurHexa;
		break;
		
	default :
		break;
	} /* end switch */

	// Cryptage de la requete
	$requete_crypte	=	$this->Crypte($requete_clair, $this->Cle);
	
	// Envoi de la requete a la plateforme UNIMESS.NET
	$fp = fopen("http://www.unimess.net/gateway.php?IdLogin=".$this->IdLogin."&Req=$requete_crypte", "r");

	// Recuperation du resultat a la requete
	while (!feof($fp)) 
	{
		$ligne[] = trim(fgets($fp, 2048));
	} /* end while */
	fclose($fp);
	// Traitement du resulat de la requete
	if ($ligne[0]=="OK") // le message est envoye
		$this->Status	=	1;
	else
		$this->Status	=	-1;
	$this->Info	=	$ligne[1];
} /* End function SendSMS() */


/**************************************************************/
/********************* Private function ***********************/
/**************************************************************/

function GenerationCle($Texte,$CleDEncryptage) 
{ 
  $CleDEncryptage = md5($CleDEncryptage); 
  $Compteur=0; 
  $VariableTemp = ""; 
  for ($Ctr=0;$Ctr<strlen($Texte);$Ctr++) 
  { 
    if ($Compteur==strlen($CleDEncryptage))
      $Compteur=0; 
    $VariableTemp.= substr($Texte,$Ctr,1) ^ substr($CleDEncryptage,$Compteur,1); 
    $Compteur++; 
  } 
  return $VariableTemp; 
} 

function Crypte($Texte,$Cle) 
{ 
  srand((double)microtime()*1000000); 
  $CleDEncryptage = md5(rand(0,32000) ); 
  $Compteur=0; 
  $VariableTemp = ""; 
  for ($Ctr=0;$Ctr<strlen($Texte);$Ctr++) 
    { 
    if ($Compteur==strlen($CleDEncryptage)) 
      $Compteur=0; 
    $VariableTemp.= substr($CleDEncryptage,$Compteur,1).(substr($Texte,$Ctr,1) ^ substr($CleDEncryptage,$Compteur,1) ); 
    $Compteur++;
    } 
  return base64_encode($this->GenerationCle($VariableTemp,$Cle) );
} 

} // end class Unimess


?>